#include "rentalAgency.h"
#include <cstdio>
#include <iostream>
#include <string>
#include <fstream>

using namespace std;

RentalAgency::RentalAgency(char* n, int z)
{
	copyString(name, n);
	zipcode = z;
	carCount = 0;
}

RentalAgency::RentalAgency(){}

void RentalAgency::addCar(RentalCar car)
{
	if (carCount < 5)
	{
		inventory[carCount] = car;
		carCount++;
	}
}

char* RentalAgency::getName()
{
	return name;
}

int RentalAgency::getZip()
{
	return zipcode;
}

void RentalAgency::display()
{
	cout << name << " " << zipcode << endl;
	for (int i = 0; i < 5; i++)
	{
		inventory[i].displayCarData();
	}
}

float RentalAgency::getCostByCarNumber(int n)
{
	return inventory[n - 1].getPrice();
}

void RentalAgency::printAvailableCars()
{
	for (int i = 0; i < 5; i++)
	{
		if (inventory[i].getAvailability())
			inventory[i].displayCarData();
	}
}

RentalCar RentalAgency::mostExpensiveCar()
{
	int expIndex = 0;
	float maxprice = inventory[0].getPrice();

	for (int i = 1; i < 5; i++)
	{
		if (inventory[i].getPrice() > maxprice)
		{
			maxprice = inventory[i].getPrice();
			expIndex = i;
		}
	}
	return inventory[expIndex];
}